//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Ui 1.0

Rectangle {
    id : uiDropDownBg

    property bool readOnly : false

    color : UiColors.getColor(UiColors.White)
    border {
        width : 1
        color : UiColors.getColor(UiColors.ControlGrey20)
    }

    UiColorizedImage {
        id : indicator

        anchors {
            right          : uiDropDownBg.right
            rightMargin    : 6
            verticalCenter : uiDropDownBg.verticalCenter
        }
        source : "qrc:/ui/images/dropdown-indicator.png"
        color  : "transparent"
    }

    states : [
        State {
            name : "disabled"
            when : !uiDropDownBg.enabled

            PropertyChanges {
                target : uiDropDownBg
                border.color : UiColors.getColor(
                                   UiColors.DisabledLightGrey13)
            }
            PropertyChanges {
                target : indicator
                color  : UiColors.getColor(UiColors.DisabledLightGrey13)
            }
        },
        State {
            name : "readonly"
            when : uiDropDownBg.readOnly

            PropertyChanges {
                target : indicator
                color  : UiColors.getColor(UiColors.DisabledLightGrey13)
            }
        },
        State {
            name : "pressed"
            when : parent && (parent.pressed || parent.open)

            PropertyChanges {
                target : uiDropDownBg
                border.color  : UiColors.getColor(UiColors.SelectionGreen)
            }
            PropertyChanges {
                target : indicator
                color  : UiColors.getColor(UiColors.SelectionGreen)
            }
        },
        State {
            name : "hover"
            when : parent && (parent.hovered || parent.activeFocus)

            PropertyChanges {
                target : uiDropDownBg
                border.color  : UiColors.getColor(UiColors.HoverGreen)
            }
            PropertyChanges {
                target : indicator
                color  : UiColors.getColor(UiColors.HoverGreen)
            }
        }
    ]
}

